<?php

use JNews\Module\ModuleViewAbstract;
use JNews\Tiktok\Util\JNews_Tiktok_Render;
use JNews\Tiktok\Util\Render;
use JNews\Tiktok\Util\JNews_Tiktok_Api;

/**
 * JNews Tiktok Element
 *
 * @author Jegtheme
 * @since 1.0.0
 * @package jnews-tiktok
 */
class JNews_Footer_Tiktok_View extends ModuleViewAbstract {

	public function render_module( $attr, $column_class ) {
		//see iQ4nWlII
		$tiktok_data = (new JNews_Tiktok_Api())->check_cache();
		if($tiktok_data) {
			$param = array(
				'row'      => $attr['footer_tiktok_row'],
				'column'   => $attr['footer_tiktok_column'],
				'sort'     => $attr['footer_tiktok_sort_type'],
				'hover'    => $attr['footer_tiktok_hover_style'],
				'open'     => $attr['footer_tiktok_open'] ? 'target=\'_blank\'' : '',
				'layout'   => $attr['footer_tiktok_layout'],
				'button'   => $attr['footer_tiktok_view_button'],
				'cover'    => $attr['footer_tiktok_cover'],
			);
			$tiktok = new JNews_Tiktok_Render( $param, $tiktok_data );

			return $tiktok->generate_element( false );
		} else {
			echo jnews_sanitize_output( '<div class="jeg_empty_module">' . jnews_return_translation( 'You\'re not logged into Tiktok, please login', 'jnews-tiktok', 'tiktok_not_logged_in' ) . '<a href="' . get_site_url() . '/wp-admin/customize.php?autofocus[section]=jnews_tiktok_feed_section">' . jnews_return_translation( ' here', 'jnews-tiktok', 'tiktok_not_logged_in_here' ) .  '</a></div>' );
		}
	}
}
